import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { AgenciesTableClient } from "@/features/feeds/components/agencies.table.client";
import { BuildsButtonTriggerPublish } from "@/features/feeds/components/builds.button-trigger-publish";
import { StatusRevalidateBanner } from "@/features/feeds/components/status.revalidate-banner";
import { WorkflowDialogClient } from "@/features/feeds/components/workflow.dialog.client";

export const dynamic = 'force-dynamic'

export default async function AgencyFeeds() {
  return (
    <div className="flex flex-col gap-3 w-full overflow-hidden rounded-sm">
      <StatusRevalidateBanner />

      <div className="grid place-items-end">
        <BuildsButtonTriggerPublish />
      </div>

      <Card>
        <CardHeader className="relative">
          <CardTitle>Agency feeds</CardTitle>
          <CardDescription>Showing all agencies you can edit and upload files to.</CardDescription>
        </CardHeader>

        <CardContent className="pb-0">
          <AgenciesTableClient />
        </CardContent>
      </Card>

      <WorkflowDialogClient />
    </div>
  );
}

